import sys
import math

input = sys.stdin.readline
EPS = 1e-12

n = int(input())
v = []

for i in range(n):
    x, y = map(int, input().split())
    v.append((math.atan2(y, x), x, y, i + 1))

v.sort()

a = v + [(ang + 2 * math.pi, x, y, idx) for ang, x, y, idx in v]

sx = sy = 0
best = 0
L = 0
bestL = bestR = 0

for R in range(len(a)):
    sx += a[R][1]
    sy += a[R][2]

    while a[R][0] - a[L][0] > math.pi + EPS:
        sx -= a[L][1]
        sy -= a[L][2]
        L += 1

    val = sx * sx + sy * sy
    if val > best:
        best = val
        bestL = L
        bestR = R

ans = []
for i in range(bestL, bestR + 1):
    if a[i][3] <= n:
        ans.append(a[i][3])

print(len(ans))
print(*ans)